<?php
	session_start();
	if ($_SESSION['unohs'] == null) {
		header("location:index.php?msg=unauthorized");
	}
?>
<?php
	include ("conn.php");

	
if(isset($_POST['update_commission'])) {
    $level = $_POST['level'];
    $rate = $_POST['rate'];
    
    $update_query = "UPDATE commission_rates 
                    SET commission_percentage = ? 
                    WHERE level = ?";
    
    $stmt = $conn->prepare($update_query);
    $stmt->bind_param("di", $rate, $level);
    $stmt->execute();
}

?>

<!DOCTYPE html>
<html lang="en">

<head>
	<meta charset="utf-8">
	<meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
	<title>Dashboard</title>
	<link rel="stylesheet" href="vendors/mdi/css/materialdesignicons.min.css">
	<link rel="stylesheet" href="vendors/feather/feather.css">
	<link rel="stylesheet" href="vendors/base/vendor.bundle.base.css">
	<link rel="stylesheet" href="vendors/flag-icon-css/css/flag-icon.min.css"/>
	<link rel="stylesheet" href="vendors/font-awesome/css/font-awesome.min.css">
	<link rel="stylesheet" href="vendors/jquery-bar-rating/fontawesome-stars-o.css">
	<link rel="stylesheet" href="vendors/jquery-bar-rating/fontawesome-stars.css">
	<link rel="stylesheet" href="css/style.css">
	<link rel="stylesheet" href="plugins/datatables/dataTables.bootstrap.css">
	<link rel="stylesheet" href="https://cdn.datatables.net/1.12.1/css/jquery.dataTables.min.css">
	<link rel="stylesheet" href="https://cdn.datatables.net/fixedheader/3.2.3/css/fixedHeader.dataTables.min.css">
	<link rel="shortcut icon" href="images/favicon.png" />
	<style>
		.cool-input {
			border: 2px solid #007bff;
			border-radius: 0.25rem;
			padding: 0.5rem 1rem;
			font-size: 1rem;
			transition: all 0.3s ease;
		}
		.cool-input:focus {
			border-color: #0056b3;
			box-shadow: 0 0 0 0.2rem rgba(0, 123, 255, 0.25);
		}
		.cool-input::placeholder {
			color: #6c757d;
			opacity: 1;
		}
		.cool-button {
			padding: 0.5rem 1rem;
			font-size: 1rem;
			border-radius: 0.25rem;
			transition: all 0.3s ease;
		}
		.cool-button:hover {
			background-color: #0056b3;
			color: #fff;
		}
		.cool-button.btn-secondary:hover {
			background-color: #343a40;
			color: #fff;
		}
		#copied {
			visibility: hidden;
			z-index: 1;
			position: fixed;
			bottom: 50%;
			background-color: #333;
			color: #fff;
			border-radius: 6px;
			padding: 16px;
			max-width: 250px;
			font-size: 17px;
		}
		#copied.show {
			visibility: visible;
			-webkit-animation: fadein 0.5s, fadeout 0.5s 2.5s;
			animation: fadein 0.5s, fadeout 0.5s 2.5s;
		}

		
.table-responsive {
    margin-top: 20px;
}

.form-control.cool-input {
    max-width: 120px;
}

.btn-primary.cool-button {
    background-color: #007bff;
    border-color: #007bff;
    color: white;
}

.btn-primary.cool-button:hover {
    background-color: #0056b3;
    border-color: #0056b3;
}
	</style>
</head>

<body>
	<div class="container-scroller">
		<nav class="navbar col-lg-12 col-12 p-0 fixed-top d-flex flex-row">
			<div class="text-center navbar-brand-wrapper d-flex align-items-center justify-content-center">
				<a class="navbar-brand brand-logo" href="dashboard.php"><img src="images/logo.png" alt="logo" /></a>
				<a class="navbar-brand brand-logo-mini" href="dashboard.php"><img src="images/logo-mini.png" alt="logo" /></a>
			</div>
			<div class="navbar-menu-wrapper d-flex align-items-center justify-content-end">
				<button class="navbar-toggler navbar-toggler align-self-center" type="button" data-toggle="minimize">
					<span class="icon-menu"></span>
				</button>
				<ul class="navbar-nav navbar-nav-right">
					<li class="nav-item dropdown d-flex mr-4 ">
						<a class="nav-link count-indicator dropdown-toggle d-flex align-items-center justify-content-center" id="notificationDropdown" href="#" data-toggle="dropdown">
							<i class="icon-cog"></i>
						</a>
						<div class="dropdown-menu dropdown-menu-right navbar-dropdown preview-list" aria-labelledby="notificationDropdown">
							<p class="mb-0 font-weight-normal float-left dropdown-header">Settings</p>
							<a class="dropdown-item preview-item" href="logout.php">
								<i class="icon-inbox"></i> Logout
							</a>
						</div>
					</li>
				</ul>
				<button class="navbar-toggler navbar-toggler-right d-lg-none align-self-center" type="button" data-toggle="offcanvas">
					<span class="icon-menu"></span>
				</button>
			</div>
		</nav>
		<div class="container-fluid page-body-wrapper">
			<nav class="sidebar sidebar-offcanvas" id="sidebar">
				<div class="user-profile">
					<div class="user-image">
						<img src="images/faces/face28.png">
					</div>
					<div class="user-name"></div>
					<div class="user-designation">
						Developer
					</div>
				</div>
				<?php include 'compass.php'; ?>
			</nav>
			<div class="main-panel">
				<div class="content-wrapper">
				
<div class="row">
    <div class="col-md-12 grid-margin stretch-card">
        <div class="card">
            <div class="card-body">
                <h4 class="card-title">Commission Rates Management</h4>
                <div class="table-responsive">
                    <table class="table table-striped">
                        <thead>
                            <tr>
                                <th>Level</th>
                                <th>Commission Rate (%)</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php 
                            $rates_query = "SELECT * FROM commission_rates ORDER BY level ASC";
                            $rates_result = $conn->query($rates_query);
                            while($row = mysqli_fetch_assoc($rates_result)) { 
                            ?>
                            <tr>
                                <form method="POST">
                                    <td><?php echo $row['level']; ?></td>
                                    <td>
                                        <input type="number" class="form-control cool-input" 
                                               step="0.01" name="rate" 
                                               value="<?php echo $row['commission_percentage']; ?>">
                                    </td>
                                    <td>
                                        <input type="hidden" name="level" 
                                               value="<?php echo $row['level']; ?>">
                                        <button type="submit" name="update_commission" 
                                                class="btn btn-primary cool-button">
                                            Update
                                        </button>
                                    </td>
                                </form>
                            </tr>
                            <?php } ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
<script>
// Add success message after commission update
<?php if(isset($_POST['update_commission'])) { ?>
    alert('Commission rate updated successfully!');
<?php } ?>

// Initialize DataTable for commission rates
$(document).ready(function() {
    $('.table').DataTable({
        "ordering": false,
        "info": false,
        "searching": false,
        "lengthChange": false,
        "pageLength": 10
    });
});
</script>
				</div>
				<footer class="footer">
					<div class="d-sm-flex justify-content-center justify-content-sm-between">
						<span class="text-muted d-block text-center text-sm-left d-sm-inline-block">Copyright © Igaming Developers</span>
					</div>
				</footer>
			</div>
		</div>
	</div>
	<script src="vendors/base/vendor.bundle.base.js"></script>
	<script src="js/off-canvas.js"></script>
	<script src="js/hoverable-collapse.js"></script>
	<script src="js/template.js"></script>
	<script src="vendors/chart.js/Chart.min.js"></script>
	<script src="vendors/jquery-bar-rating/jquery.barrating.min.js"></script>
	<script src="js/dashboard.js"></script>
	<script src="https://cdn.datatables.net/1.12.1/js/jquery.dataTables.min.js"></script>
	<script>
		if (window.history.replaceState) {
			window.history.replaceState(null, null, window.location.href);
		}
	</script>
</body>

</html>
